/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.list;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class ThreadedAvlTree<T> {
    private final Comparator<T> comparator;
    private Node<T> root;
    private int size;
    private final Deque<Node<T>> storedPath;

    public ThreadedAvlTree(Comparator<T> comparator) {
        this.comparator = comparator;
        this.root = null;
        this.size = 0;
        this.storedPath = new ArrayDeque<Node<T>>(20);
    }

    public T getRootValue() {
        if (this.root == null) {
            throw new NoSuchElementException();
        }
        return this.root.value;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    public boolean isBalanced() {
        if (this.root == null) {
            return true;
        }
        return this.root.isRealBalanced();
    }

    public boolean isEmpty() {
        if (this.size == 0) {
            assert (this.root == null);
            return true;
        }
        assert (this.root != null);
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public void insert(T value) {
        if (this.root == null) {
            this.root = new Node<T>(value);
            this.size = 1;
            return;
        }
        this.storedPath.clear();
        Node<T> n = this.root;
        while (n != null) {
            int cmp = this.comparator.compare(value, n.value);
            if (cmp >= 0) {
                if (!n.rightThread) {
                    this.storedPath.push(n);
                    n = n.right;
                    continue;
                }
                Node<T> f = new Node<T>(value);
                f.right = n.right;
                f.rightThread = true;
                f.left = n;
                f.leftThread = true;
                n.right = f;
                n.rightThread = false;
                ++this.size;
                break;
            }
            if (cmp >= 0) continue;
            if (!n.leftThread) {
                this.storedPath.push(n);
                n = n.left;
                continue;
            }
            Node<T> f = new Node<T>(value);
            f.left = n.left;
            f.leftThread = true;
            f.right = n;
            f.rightThread = true;
            n.left = f;
            n.leftThread = false;
            ++this.size;
            break;
        }
        this.rebalanceStoredPath();
        assert (this.root.isRealBalanced());
    }

    public boolean containsAnyInstance(T value) {
        return this.remove(value, Equality.ANY_INSTANCE, true);
    }

    public boolean containsInstance(T value) {
        return this.remove(value, Equality.EXACT_INSTANCE, true);
    }

    public boolean containsEquals(T value) {
        return this.remove(value, Equality.EQUALS, true);
    }

    public void removeAnyInstance(T value) {
        if (!this.remove(value, Equality.ANY_INSTANCE, false)) {
            throw new NoSuchElementException();
        }
    }

    public void removeInstance(T value) {
        if (!this.remove(value, Equality.EXACT_INSTANCE, false)) {
            throw new NoSuchElementException();
        }
    }

    public void removeEquals(T value) {
        if (!this.remove(value, Equality.EQUALS, false)) {
            throw new NoSuchElementException();
        }
    }

    private boolean remove(T value, Equality equality, boolean findOnly) {
        if (this.root == null) {
            return false;
        }
        this.storedPath.clear();
        Node<T> q = null;
        Node<T> p = this.root;
        boolean last_move_left = false;
        while (p != null) {
            int cmp = this.comparator.compare(value, p.value);
            if (cmp == 0) {
                ArrayDeque<Node> stack = new ArrayDeque<Node>();
                HashMap parentOf = new HashMap();
                stack.addFirst(p);
                boolean found = false;
                Node<T> open = null;
                while (!stack.isEmpty()) {
                    open = (Node<T>)stack.removeFirst();
                    assert (this.comparator.compare(value, open.value) == 0);
                    switch (equality) {
                        case ANY_INSTANCE: {
                            found = true;
                            System.out.println("find instance: " + open);
                            break;
                        }
                        case EXACT_INSTANCE: {
                            if (open.value != value) break;
                            found = true;
                            break;
                        }
                        case EQUALS: {
                            if (!open.value.equals(value)) break;
                            found = true;
                        }
                    }
                    if (found) break;
                    if (!open.leftThread && open.left != null && this.comparator.compare(open.left.value, value) == 0) {
                        stack.addFirst(open.left);
                        parentOf.put(open.left, open);
                    }
                    if (open.rightThread || open.right == null || this.comparator.compare(open.right.value, value) != 0) continue;
                    stack.addFirst(open.right);
                    parentOf.put(open.right, open);
                }
                if (!found) {
                    return false;
                }
                if (findOnly) {
                    return true;
                }
                assert (open != null);
                stack.clear();
                Node<T> temp = open;
                while (parentOf.containsKey(temp)) {
                    stack.addFirst((Node)parentOf.get(temp));
                    temp = (Node)parentOf.get(temp);
                }
                while (!stack.isEmpty()) {
                    this.storedPath.addFirst((Node)stack.pop());
                }
                p = open;
                if (this.storedPath.isEmpty()) {
                    assert (q == null);
                    assert (p == this.root);
                } else {
                    q = this.storedPath.getFirst();
                    assert (p == q.left || p == q.right);
                    last_move_left = p == q.left;
                }
                if (p.rightThread) {
                    if (!p.leftThread) {
                        Node t = p.left;
                        while (!t.rightThread) {
                            t = t.right;
                        }
                        t.right = p.right;
                        if (q == null) {
                            this.root = p.left;
                        } else if (last_move_left) {
                            q.left = p.left;
                        } else {
                            q.right = p.left;
                        }
                    } else if (q == null) {
                        this.root = null;
                    } else if (last_move_left) {
                        q.left = p.left;
                        q.leftThread = true;
                    } else {
                        q.right = p.right;
                        q.rightThread = true;
                    }
                } else if (p.right.leftThread) {
                    p.right.left = p.left;
                    p.right.leftThread = p.leftThread;
                    if (!p.right.leftThread) {
                        Node t = p.right.left;
                        while (!t.rightThread) {
                            t = t.right;
                        }
                        t.right = p.right;
                    }
                    if (q == null) {
                        this.root = p.right;
                    } else if (last_move_left) {
                        q.left = p.right;
                    } else {
                        q.right = p.right;
                    }
                    this.storedPath.push(p.right);
                } else {
                    Node n = p.right;
                    while (!n.leftThread) {
                        n = n.left;
                    }
                    this.storedPath.push(n);
                    Node r = p.right;
                    Node s2 = p.right.left;
                    this.storedPath.push(r);
                    while (!s2.leftThread) {
                        r = s2;
                        s2 = s2.left;
                        this.storedPath.push(r);
                    }
                    if (!s2.rightThread) {
                        r.left = s2.right;
                    } else {
                        r.left = s2;
                        r.leftThread = true;
                    }
                    s2.left = p.left;
                    s2.leftThread = p.leftThread;
                    if (!s2.leftThread) {
                        Node t = p.left;
                        while (!t.rightThread) {
                            t = t.right;
                        }
                        t.right = s2;
                    }
                    s2.right = p.right;
                    s2.rightThread = false;
                    if (q == null) {
                        this.root = s2;
                    } else if (last_move_left) {
                        q.left = s2;
                    } else {
                        q.right = s2;
                    }
                }
                --this.size;
                break;
            }
            if (cmp > 0) {
                if (!p.rightThread) {
                    this.storedPath.push(p);
                    q = p;
                    p = p.right;
                    last_move_left = false;
                    continue;
                }
                return false;
            }
            if (cmp >= 0) continue;
            if (!p.leftThread) {
                this.storedPath.push(p);
                q = p;
                p = p.left;
                last_move_left = true;
                continue;
            }
            return false;
        }
        if (findOnly) {
            throw new IllegalStateException("This section should be executed by REMOVAL methods only.");
        }
        this.rebalanceStoredPath();
        assert (this.root == null || this.root.isRealBalanced());
        return true;
    }

    private void rebalanceStoredPath() {
        if (this.storedPath.isEmpty()) {
            return;
        }
        while (this.storedPath.size() > 1) {
            Node<T> child = this.storedPath.pop();
            Node<T> parent = this.storedPath.peek();
            if (child != parent.left && child != parent.right) {
                throw new IllegalStateException(String.format("Tree rebalance path invalid! Node '%s' is not a child of '%s' (it has L: '%s', R: '%s').", child, parent, parent.left, parent.right));
            }
            if (child == parent.left) {
                parent.left = this.rebalanceNode(child);
                continue;
            }
            parent.right = this.rebalanceNode(child);
        }
        assert (this.storedPath.size() == 1);
        assert (this.storedPath.peek() == this.root);
        this.root = this.rebalanceNode(this.storedPath.pop());
    }

    private Node<T> rebalanceNode(Node<T> node) {
        assert (node != null);
        int balance = node.getRealBalance();
        assert (Math.abs(balance) <= 2);
        if (balance == -2) {
            if (node.right.getRealBalance() <= 0) {
                return this.rotateLeft(node);
            }
            node.right = this.rotateRight(node.right);
            return this.rotateLeft(node);
        }
        if (balance == 2) {
            if (node.left.getRealBalance() >= 0) {
                return this.rotateRight(node);
            }
            node.left = this.rotateLeft(node.left);
            return this.rotateRight(node);
        }
        return node;
    }

    private Node<T> rotateLeft(Node<T> oldRoot) {
        assert (oldRoot != null);
        Node newRoot = oldRoot.right;
        if (newRoot.leftThread) {
            newRoot.left = oldRoot;
            newRoot.leftThread = false;
            oldRoot.right = newRoot;
            oldRoot.rightThread = true;
        } else {
            oldRoot.right = newRoot.left;
            newRoot.left = oldRoot;
        }
        return newRoot;
    }

    private Node<T> rotateRight(Node<T> oldRoot) {
        assert (oldRoot != null);
        Node newRoot = oldRoot.left;
        if (newRoot.rightThread) {
            newRoot.right = oldRoot;
            newRoot.rightThread = false;
            oldRoot.left = newRoot;
            oldRoot.leftThread = true;
        } else {
            oldRoot.left = newRoot.right;
            newRoot.right = oldRoot;
        }
        return newRoot;
    }

    public T getMinimum() {
        Node<T> n = this.getMinimumNode();
        if (n == null) {
            return null;
        }
        return n.value;
    }

    public T getMaximum() {
        Node<T> n = this.getMaximumNode();
        if (n == null) {
            return null;
        }
        return n.value;
    }

    protected Node<T> getMinimumNode() {
        if (this.root == null) {
            return null;
        }
        return this.getMinimumNode(this.root);
    }

    protected Node<T> getMaximumNode() {
        if (this.root == null) {
            return null;
        }
        return this.getMaximumNode(this.root);
    }

    protected Node<T> getMinimumNode(Node<T> start) {
        assert (start != null);
        Node<T> temp = start;
        while (!temp.leftThread && temp.left != null) {
            temp = temp.left;
        }
        return temp;
    }

    protected Node<T> getMaximumNode(Node<T> start) {
        assert (start != null);
        Node<T> temp = start;
        while (!temp.rightThread && temp.right != null) {
            temp = temp.right;
        }
        return temp;
    }

    protected Node<T> getNextOf(T value) {
        if (value == null) {
            throw new NullPointerException("Cannot get nearest next node of NULL value.");
        }
        if (this.root == null) {
            return null;
        }
        Node<T> node = this.root;
        while (true) {
            int cmp;
            if ((cmp = this.comparator.compare(value, node.value)) == 0) {
                return node;
            }
            if (cmp > 0) {
                if (!node.rightThread && node.right != null) {
                    node = node.right;
                    continue;
                }
                return node.right;
            }
            if (node.leftThread || node.left == null) break;
            node = node.left;
        }
        return node;
    }

    protected Node<T> getPreviousOf(T value) {
        if (value == null) {
            throw new NullPointerException("Cannot get nearest next node of NULL value.");
        }
        if (this.root == null) {
            return null;
        }
        Node<T> node = this.root;
        while (true) {
            int cmp;
            if ((cmp = this.comparator.compare(value, node.value)) > 0) {
                if (!node.rightThread && node.right != null) {
                    node = node.right;
                    continue;
                }
                return node;
            }
            if (node.leftThread || node.left == null) break;
            node = node.left;
        }
        return node.left;
    }

    public String toString() {
        if (this.root == null) {
            return "(empty TAVL tree)";
        }
        return "TAVL tree with " + this.size + " node(s)";
    }

    protected static class Node<T> {
        protected final T value;
        protected Node<T> left;
        protected Node<T> right;
        protected boolean leftThread;
        protected boolean rightThread;

        public Node(T value) {
            this.value = value;
            this.left = null;
            this.right = null;
            this.leftThread = true;
            this.rightThread = true;
        }

        public int getRealBalance() {
            int ml = -1;
            int mr = -1;
            if (!this.leftThread && this.left != null) {
                ml = this.left.getRealHeight();
            }
            if (!this.rightThread && this.right != null) {
                mr = this.right.getRealHeight();
            }
            return ml - mr;
        }

        public int getRealHeight() {
            int ml = -1;
            int mr = -1;
            if (!this.leftThread && this.left != null) {
                ml = this.left.getRealHeight();
            }
            if (!this.rightThread && this.right != null) {
                mr = this.right.getRealHeight();
            }
            return 1 + Math.max(ml, mr);
        }

        public boolean isRealBalanced() {
            if (!this.leftThread && this.left != null && !this.left.isRealBalanced()) {
                System.out.println("left subtree " + this.left + " of " + this + " is disbalanced = " + this.left.getRealBalance());
                return false;
            }
            if (!this.rightThread && this.right != null && !this.right.isRealBalanced()) {
                System.out.println("right subtree " + this.right + " of " + this + " is disbalanced = " + this.right.getRealBalance());
                return false;
            }
            if (Math.abs(this.getRealBalance()) > 1) {
                System.out.println("tree " + this + " is disbalanced = " + this.getRealBalance());
                return false;
            }
            return true;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static enum Equality {
        ANY_INSTANCE,
        EXACT_INSTANCE,
        EQUALS;

    }
}

